close all
clearvars
gatingwrapper;
gatingfilename=filenameglobal;
fluorescencewrapper;
timeoffset=zeros(gating_examine_start-fluo_examine_start,num_sweeps);
offsetq=[timeoffset;q_data.qintegrated.(gatingfilename)];
overlayduration=size(offsetq,1);
timefluo=time;
close all

%Check if you need to invert the fluorescence
invert_fluorescence_check=questdlg('Does the fluorescence need to be inverted?');

%Plot the graph, saving the variables for later formatting changes
if (strcmp (invert_fluorescence_check,'Yes'))
    [hAx,hLine1,hLine2]=plotyy(timefluo(1:overlayduration),f_data.ftraces.(filenameglobal)(1:overlayduration,:)*-1,timefluo(1:overlayduration),offsetq*1e12);
else
    [hAx,hLine1,hLine2]=plotyy(timefluo(1:overlayduration),f_data.ftraces.(filenameglobal)(1:overlayduration,:),timefluo(1:overlayduration),offsetq*1e12);
end

%Make formatting changes now (font size, axes width, etc)
box off;
set(gcf,'color','w','Position',[0,0,750,650]);
xlabel('Time (ms)','FontWeight','bold','FontSize',18,'FontName','Arial');
ylabel(hAx(1),'\Delta F/F_o (%)','FontWeight','bold','FontSize',18,'FontName','Arial');
ylabel(hAx(2),'Q (pC)','FontWeight','bold','FontSize',18,'FontName','Arial');
set(hAx(1), 'LineWidth',3,'FontWeight','bold','FontSize',18, 'Position', [.13,.11,.74,.815]);
set(hAx(2), 'LineWidth',3,'FontWeight','bold','FontSize',18,'Position', [.13,.11,.74,.815]);

for i=1:num_sweeps
hLine1(i).LineWidth=2;
hLine2(i).LineWidth=2;
end

saveas(gcf,filenameglobal,'fig')
save(filenameglobal)
close all
clearvars